package gov.va.med.mhv.usermgmt.persist.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPv3;

public abstract class LdapQuery extends LdapFunction {
	private List queryConditions;
	private List attributes;
	private static final String[] EMPTY_STRING_ARRAY = new String[0];
	
	public LdapQuery() {
		super();
		this.queryConditions = new ArrayList(4);
		this.attributes = new ArrayList();
	}
	
	public Collection executeQuery() {
		if(!conn.isConnected())
			throw new IllegalStateException("LDAPConnection is not connected to the server.");
		
		try {
			LDAPSearchResults results = conn.search(
				env.getBaseDn(), LDAPv3.SCOPE_SUB, buildFilter(), getSearchAttributes(), false);
			
			return processSearchResult(results);
		}
		catch(LDAPException e) {
			throw new LdapException("Exception executing directory search", e);
		}
		finally {
			disconnect();
		}
	}
	
	public void addCondition(LdapQueryCondition condition) {
		queryConditions.add(condition);
	}
	
	public void addAttribute(String attribute) {
		if(attribute == null)
			throw new NullPointerException();
		
		if(!attributes.contains(attribute))
			this.attributes.add(attribute);
	}
	
	protected abstract Collection processSearchResult(LDAPSearchResults results);
	
	protected String buildFilter() {
		StringBuffer filterBuf = new StringBuffer();
		
		for(Iterator i = queryConditions.iterator(); i.hasNext();) {
			LdapQueryCondition condition = (LdapQueryCondition)i.next();
			filterBuf.append(condition.toQueryString());
		}
		
		return filterBuf.toString();
	}
	
	protected String[] getSearchAttributes() {
		return attributes.isEmpty() ? 
			EMPTY_STRING_ARRAY : 
			(String[])attributes.toArray(new String[attributes.size()]);
	}
}
